#!/usr/bin/python -u
import os
import xenprototypeModulesCarrier
from xenprototype.VirtualManagementLib.virtualManagement import PhysicalHost
from xenprototype.CpuAllocation.cpuFeedbackControl import *
from xenprototype.CpuAllocation.statistics import *

testName = "PaperWeightTwoVMDiffPacketSize"

rounds = 30
count = 1
prefix = "eXpErImEnT"
testName = prefix + testName
testTime = 100

os.popen("rm " + str(testName) + "*")

while (count <= rounds):

	#Test Without Controller
	
	physicalHost = PhysicalHost("floresta","xen+ssh")
	physicalHost.setSchedParametersCap(0,4)
	physicalHost.setSchedParametersCap(0,6)
	physicalHost.printSchedParameters()
	
	
	
	test1 = IperfTest(testTime,1,1470,705600,"10.0.1.3",str(str(testName) + "Without1470_" + str(count)),"146.164.69.149","5001")
	test2 = IperfTest(testTime,1,64,51200,"10.0.3.3",str(str(testName) + "Without64_" + str(count)),"146.164.69.149","5002")

	IperfThread("2",test2).start()
	IperfThread("3",test1).start()


	while (test1.done == False) and (test2.done == False):
		#physicalHost.printSchedParameters()
		os.popen("sleep 1")

	averageThroughputList=[]

	os.popen("sleep 5")

	#Compute statistics for VM1	

	statistic = Statistics(str(str(testName) + "Without1470_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("1 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("1 " + str(statistic.rmse) + "\n")
	output.close()	

	averageThroughputList.append(statistic.average)
	del statistic

	#Compute statistics for VM2	

	statistic = Statistics(str(str(testName) + "Without64_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("2 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("2 " + str(statistic.rmse) + "\n")
	output.close()

	averageThroughputList.append(statistic.average)
	del statistic	

	#Compute Fairness

	fairness = Fairness(averageThroughputList)

	output = open(str(testName + "JainFairness"),'a')
	output.write("1 " + str(fairness.jainFairness) + "\n")
	output.close()
	
	
	del fairness
	del test1
	del test2
	del physicalHost	
	
	#Test with controller
		
	os.popen("killall iperf")

	physicalHost = PhysicalHost("floresta","xen+ssh")
	physicalHost.setSchedParametersCap(0,4)
	physicalHost.setSchedParametersCap(0,6)
	physicalHost.printSchedParameters()

	#Perform the experiment using Controller On

	test1 = IperfTest(testTime,1,1470,705600,"10.0.1.3",str(str(testName) + "Controller1470_" + str(count)),"146.164.69.149","5001")
	test2 = IperfTest(testTime,1,64,51200,"10.0.3.3",str(str(testName) + "Controller64_" + str(count)),"146.164.69.149","5002")

	physicalHost = PhysicalHost("floresta","xen+ssh")

	samplePeriod = 1
	errorPercentageAcceptable = 0.1
	minPercentageSamplePeriod = 1
	constantCap = 0

	#Settings for VM1

	kp=float(-0.000000362)
	ki=float(0.000000700)
	desiredThroughput = 400000
	operationalPointThroughput = 600000

	control1 = ThroughputControl(kp,ki,operationalPointThroughput,desiredThroughput,samplePeriod,errorPercentageAcceptable,minPercentageSamplePeriod,constantCap,4,physicalHost,test1)

	ControlThread("10001",control1).start()
	IperfThread("2",test2).start()


	while (control1.done == "False") and (test2.done == False):
		#physicalHost.printSchedParameters()
		os.popen("sleep 1")

	averageThroughputList=[]
	
	os.popen("sleep 5")

	#Compute statistics for VM1	

	statistic = Statistics(str(str(testName) + "Controller1470_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("3 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("3 " + str(statistic.rmse) + "\n")
	output.close()	

	averageThroughputList.append(statistic.average)
	del statistic

	#Compute statistics for VM2	

	statistic = Statistics(str(str(testName) + "Controller64_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("4 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("4 " + str(statistic.rmse) + "\n")
	output.close()

	averageThroughputList.append(statistic.average)
	del statistic	

	#Compute Fairness

	fairness = Fairness(averageThroughputList)

	output = open(str(testName + "JainFairness"),'a')
	output.write("2 " + str(fairness.jainFairness) + "\n")
	output.close()
	del fairness

	del test2
	del physicalHost
	del control1
	del test1
	
	print "Done " + str(count)
	
	count = count + 1

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "Average") + ' >> ' + str(testName + "Average.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "RMSE") + ' >> ' + str(testName + "RMSE.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "JainFairness") + ' >> ' + str(testName + "JainFairness.dt") + "") 

