#!/usr/bin/python -u
import os
import xenprototypeModulesCarrier
from xenprototype.VirtualManagementLib.virtualManagement import PhysicalHost
from xenprototype.CpuAllocation.cpuFeedbackControl import *
from xenprototype.CpuAllocation.statistics import *

testName = "bottleNeckThreeVMIperf"

rounds = 30
count = 1
prefix = "eXpErImEnT"
testName = prefix + testName

os.popen("rm " + str(testName) + "*")

while (count <= rounds):
		
	os.popen("killall iperf")

	physicalHost = PhysicalHost("floresta","xen+ssh")
	physicalHost.setSchedParametersCap(0,1)
	physicalHost.setSchedParametersCap(0,5)
	physicalHost.setSchedParametersCap(0,6)
	physicalHost.printSchedParameters()

	#Perform the experiment using Controller On

	test1 = IperfTest(100,1,64,51200,"10.0.1.3",str(str(testName) + "OnVM1_" + str(count)),"146.164.69.149","5001")
	test2 = IperfTest(100,1,64,51200,"10.0.3.3",str(str(testName) + "OnVM2_" + str(count)),"146.164.69.149","5002")
	test3 = IperfTest(100,1,64,51200,"10.0.5.3",str(str(testName) + "OnVM3_" + str(count)),"146.164.69.149","5003")



	physicalHost = PhysicalHost("floresta","xen+ssh")

	samplePeriod = 1
	errorPercentageAcceptable = 0.1
	minPercentageSamplePeriod = 1
	constantCap = 0

	#Settings for VM1

	kp=float(-0.000003422)
	ki=float(0.000010158)
	desiredThroughput = 30000
	operationalPointThroughput = 40007

	control1 = ThroughputControl(desiredThroughput,1,physicalHost,test1,True)

	#Settings for VM2

	kp=float(-0.000004825)
	ki=float(0.000018530)	
	desiredThroughput = 15000
	operationalPointThroughput = 27023

	control2 = ThroughputControl(desiredThroughput,5,physicalHost,test2,True)
	#control2 = ThroughputControl(kp,ki,operationalPointThroughput,desiredThroughput,samplePeriod,errorPercentageAcceptable,minPercentageSamplePeriod,constantCap,4,physicalHost,test2)

	#Settings for VM3

	kp=float(-0.000004825)
	ki=float(0.000018530)
	desiredThroughput = 15000
	operationalPointThroughput = 27023

	#control3 = ThroughputControl(kp,ki,operationalPointThroughput,desiredThroughput,samplePeriod,errorPercentageAcceptable,minPercentageSamplePeriod,constantCap,7,physicalHost,test3)
	control3 = ThroughputControl(desiredThroughput,6,physicalHost,test3,True)	

	ControlThread("10001",control1).start()
	ControlThread("10002",control2).start()
	ControlThread("10003",control3).start()

	while (control1.done == "False") and (control2.done == "False") and (control3.done == "False"):
		#physicalHost.printSchedParameters()
		os.popen("sleep 1")

	averageThroughputList=[]

	os.popen("sleep 5")

	#Compute statistics for VM1	

	statistic = Statistics(str(str(testName) + "OnVM1_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("4 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("4 " + str(statistic.rmse) + "\n")
	output.close()	

	averageThroughputList.append(statistic.average)
	del statistic

	#Compute statistics for VM2	

	statistic = Statistics(str(str(testName) + "OnVM2_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("5 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("5 " + str(statistic.rmse) + "\n")
	output.close()

	averageThroughputList.append(statistic.average)
	del statistic	

	#Compute statistics for VM3	

	statistic = Statistics(str(str(testName) + "OnVM3_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("6 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("6 " + str(statistic.rmse) + "\n")
	output.close()

	averageThroughputList.append(statistic.average)
	del statistic

	#Compute Fairness

	fairness = Fairness(averageThroughputList)

	output = open(str(testName + "JainFairness"),'a')
	output.write("2 " + str(fairness.jainFairness) + "\n")
	output.close()
	del fairness

	del test1
	del test2
	del test3
	del physicalHost
	del control1
	del control2
	del control3

	print "Done " + str(count)
	
	count = count + 1

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "Average") + ' >> ' + str(testName + "Average.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "RMSE") + ' >> ' + str(testName + "RMSE.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "JainFairness") + ' >> ' + str(testName + "JainFairness.dt") + "") 

