#!/usr/bin/python -u
import os
import xenprototypeModulesCarrier
from xenprototype.VirtualManagementLib.virtualManagement import PhysicalHost
from xenprototype.CpuAllocation.cpuFeedbackControl import *
from xenprototype.CpuAllocation.statistics import *

testName = "PaperThreeVM"

rounds = 30
count = 1
prefix = "eXpErImEnT"
testName = prefix + testName

os.popen("rm " + str(testName) + "*")

while (count <= rounds):

	os.popen("killall iperf")

	#Perform the experiment using Controller Off

	physicalHost = PhysicalHost("floresta","xen+ssh")
	physicalHost.setSchedParametersCap(0,3)
	physicalHost.setSchedParametersCap(0,4)
	physicalHost.setSchedParametersCap(0,7)
	physicalHost.printSchedParameters()

	test1 = IperfTest(100,1,64,51007,"10.0.1.3",str(str(testName) + "OffVM1_" + str(count)),"146.164.69.149","5001")
	test2 = IperfTest(100,1,64,51007,"10.0.3.3",str(str(testName) + "OffVM2_" + str(count)),"146.164.69.149","5002")
	test3 = IperfTest(100,1,64,51007,"10.0.5.3",str(str(testName) + "OffVM3_" + str(count)),"146.164.69.149","5003")

	IperfThread("1",test1).start()
	IperfThread("1",test2).start()
	IperfThread("1",test3).start()


	while ((test1.done == False) and (test2.done == False) and (test3.done == False)):
		#print "Test 1 " + str(test1.lastMeasure)
		#print "Test 2 " + str(test2.lastMeasure)
		#print "Test 3 " + str(test3.lastMeasure)
		os.popen("sleep 1")

	averageThroughputList=[]

	os.popen("sleep 5")

	#Compute statistics for VM1	

	statistic = Statistics(str(str(testName) + "OffVM1_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("1 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("1 " + str(statistic.rmse) + "\n")
	output.close()	


	averageThroughputList.append(statistic.average)
	del statistic

	#Compute statistics for VM2	

	statistic = Statistics(str(str(testName) + "OffVM2_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("2 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("2 " + str(statistic.rmse) + "\n")
	output.close()

	averageThroughputList.append(statistic.average)
	del statistic

	#Compute statistics for VM3	

	statistic = Statistics(str(str(testName) + "OffVM3_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("3 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("3 " + str(statistic.rmse) + "\n")
	output.close()

	averageThroughputList.append(statistic.average)
	del statistic

	#Compute Fairness

	fairness = Fairness(averageThroughputList)

	output = open(str(testName + "JainFairness"),'a')
	output.write("1 " + str(fairness.jainFairness) + "\n")
	output.close()
	del fairness

	del test1
	del test2
	del test3
	del physicalHost

	#Perform the experiment using Controller On

	test1 = IperfTest(100,1,64,51007,"10.0.1.3",str(str(testName) + "OnVM1_" + str(count)),"146.164.69.149","5001")
	test2 = IperfTest(100,1,64,51007,"10.0.3.3",str(str(testName) + "OnVM2_" + str(count)),"146.164.69.149","5002")
	test3 = IperfTest(100,1,64,51007,"10.0.5.3",str(str(testName) + "OnVM3_" + str(count)),"146.164.69.149","5003")



	physicalHost = PhysicalHost("floresta","xen+ssh")

	samplePeriod = 1
	errorPercentageAcceptable = 0.1
	minPercentageSamplePeriod = 1
	constantCap = 0

	#Settings for VM1

	kp=float(-0.000003422)
	ki=float(0.000010158)
	desiredThroughput = 21000
	operationalPointThroughput = 40007

	control1 = ThroughputControl(kp,ki,operationalPointThroughput,desiredThroughput,samplePeriod,errorPercentageAcceptable,minPercentageSamplePeriod,constantCap,3,physicalHost,test1)

	control2 = ThroughputControl(kp,ki,operationalPointThroughput,desiredThroughput,samplePeriod,errorPercentageAcceptable,minPercentageSamplePeriod,constantCap,4,physicalHost,test2)

	control3 = ThroughputControl(kp,ki,operationalPointThroughput,desiredThroughput,samplePeriod,errorPercentageAcceptable,minPercentageSamplePeriod,constantCap,7,physicalHost,test3)


	ControlThread("10001",control1).start()
	ControlThread("10002",control2).start()
	ControlThread("10003",control3).start()

	while (control1.done == "False") and (control2.done == "False") and (control3.done == "False"):
		os.popen("sleep 1")

	averageThroughputList=[]

	os.popen("sleep 5")

	#Compute statistics for VM1	

	statistic = Statistics(str(str(testName) + "OnVM1_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("4 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("4 " + str(statistic.rmse) + "\n")
	output.close()	

	averageThroughputList.append(statistic.average)
	del statistic

	#Compute statistics for VM2	

	statistic = Statistics(str(str(testName) + "OnVM2_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("5 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("5 " + str(statistic.rmse) + "\n")
	output.close()

	averageThroughputList.append(statistic.average)
	del statistic	

	#Compute statistics for VM3	

	statistic = Statistics(str(str(testName) + "OnVM3_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("6 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("6 " + str(statistic.rmse) + "\n")
	output.close()

	averageThroughputList.append(statistic.average)
	del statistic

	#Compute Fairness

	fairness = Fairness(averageThroughputList)

	output = open(str(testName + "JainFairness"),'a')
	output.write("2 " + str(fairness.jainFairness) + "\n")
	output.close()
	del fairness

	del test1
	del test2
	del test3
	del physicalHost
	del control1
	del control2
	del control3

	print "Done " + str(count)
	count = count + 1

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "Average") + ' >> ' + str(testName + "Average.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "RMSE") + ' >> ' + str(testName + "RMSE.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "JainFairness") + ' >> ' + str(testName + "JainFairness.dt") + "") 

