#!/usr/bin/python -u
import os
import xenprototypeModulesCarrier
from xenprototype.VirtualManagementLib.virtualManagement import PhysicalHost
from xenprototype.CpuAllocation.cpuFeedbackControlGeneric import *
from xenprototype.CpuAllocation.measureThroughput import *
from xenprototype.CpuAllocation.statistics import *

#This test is done with a stress of 10% in a virtual machine with controller off (cap set in 15%) and controller on (to limit in 20000kb/s)

testName = "WithoutDisturbance"

rounds = 30
count = 1
prefix = "eXpErImEnT"
testName = prefix + testName

os.popen("rm " + str(testName) + "*")

domainID = 1

lista = ["vif1.1"]

while (count <= rounds):

	os.popen("killall iperf")

	#Perform the experiment using Controller Off

	physicalHost = PhysicalHost("floresta","xen+ssh")
	physicalHost.setSchedParametersCap(14,domainID)
	physicalHost.printSchedParameters()

	os.popen("ssh root@floresta \" killall measureThroughputServer.py \"")

	physicalHost = PhysicalHost("floresta","xen+ssh")

	cmd1 = "ssh root@tartaruga" +  " \" " + "iperf -su -l 64"  " \" "
	
	cmd2 = "iperf -c 10.0.1.3 -b 51200k -f k -l 64 -t 115 "

	subprocess.Popen(cmd1, stdout=subprocess.PIPE, shell=True)

	subprocess.Popen(cmd2, stdout=subprocess.PIPE, shell=True)
	

	medida = MeasureClient("floresta",50012,lista,100,str(str(testName) + "OffVM1_" + str(count)))

	MeasureClientThread("3",medida).start()	

	while (medida.getExperimentStatus() == True):
		os.popen("sleep 1")

	averageThroughputList=[]

	os.popen("sleep 5")

	#Compute statistics for VM1	

	statistic = Statistics(str(str(testName) + "OffVM1_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("1 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("1 " + str(statistic.rmse) + "\n")
	output.close()	


	averageThroughputList.append(statistic.average)

	del statistic
	del medida
	del physicalHost

	#Perform the experiment using Adaptive Controller With 20k of reference input

	os.popen("ssh root@floresta \" killall measureThroughputServer.py \"")

	physicalHost = PhysicalHost("floresta","xen+ssh")

	cmd1 = "ssh root@tartaruga" +  " \" " + "iperf -su -l 64"  " \" "
	
	cmd2 = "iperf -c 10.0.1.3 -b 51200k -f k -l 64 -t 115 "

	subprocess.Popen(cmd1, stdout=subprocess.PIPE, shell=True)

	subprocess.Popen(cmd2, stdout=subprocess.PIPE, shell=True)

	medida = MeasureClient("floresta",50012,lista,100,str(str(testName) + "OnVM1_" + str(count)))

	desiredThroughput = 20000

	adpativeOn = True

	domainID = 1

	control = ThroughputControl(desiredThroughput,domainID,physicalHost,medida,adpativeOn)

	control.runFeedackControl()

	statistic = Statistics(str(str(testName) + "OnVM1_" + str(count)),20)

	output = open(str(testName + "Average"),'a')
	output.write("2 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("2 " + str(statistic.rmse) + "\n")
	output.close()	

	print "Controller Adpative 20k" + str(count) + " done"

	cmd1 = "killall iperf"

	cmd2 = "ssh root@tartaruga" +  " \" " + "killall iperf"  " \" "

	subprocess.Popen(cmd1, stdout=subprocess.PIPE, shell=True)

	subprocess.Popen(cmd2, stdout=subprocess.PIPE, shell=True)

	del statistic
	del physicalHost
	del control
	del medida

	os.popen("sleep 10")
	count = count + 1

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "Average") + ' >> ' + str(testName + "Average.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "RMSE") + ' >> ' + str(testName + "RMSE.dt") + "") 
