#!/usr/bin/python -u
import os
import xenprototypeModulesCarrier
from xenprototype.VirtualManagementLib.virtualManagement import PhysicalHost
from xenprototype.CpuAllocation.cpuFeedbackControl import *
from xenprototype.CpuAllocation.statistics import *

testName = "Paper20000CountActions"

rounds = 10
count = 1
prefix = "eXpErImEnT"
testName = prefix + testName

os.popen("rm " + str(testName) + "*")

while (count <= rounds):

	#Perform the experiment using Adjusted Parameters

	test = IperfTest(100,1,64,51007,"10.0.1.3",str(str(testName) + "OnAPVM1_" + str(count)),"146.164.69.149","5001")

	kp=float(-0.000003422)
	ki=float(0.000010158)

	physicalHost = PhysicalHost("floresta","xen+ssh")
	desiredThroughput = 20000
	samplePeriod = 1
	errorPercentageAcceptable = 0
	minPercentageSamplePeriod = 1
	constantCap = 0
	operationalPointThroughput = 40007
	control = ThroughputControl	(kp,ki,operationalPointThroughput,desiredThroughput,samplePeriod,errorPercentageAcceptable,minPercentageSamplePeriod,constantCap,3,physicalHost,test)
	control.runFeedackControl()

	statistic = Statistics(str(str(testName) + "OnAPVM1_" + str(count)),20)


	output = open(str(testName + "Average"),'a')
	output.write("3 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("3 " + str(statistic.rmse) + "\n")
	output.close()	
	output = open(str(testName + "ReducedMessages"),'a')
	percentageReduced = float(1) - (float(control.actionsCount)/float(control.samplesCount))
	print str(control.actionsCount) + " / " + str(control.samplesCount)
	output.write("3 " + str(percentageReduced) + "\n")
	output.close()

	print "Controller Adjusted Parameters " + str(count) + " done"

	del statistic
	del physicalHost
	del control
	del test

	os.popen("sleep 5")

	#Perform the experiment using Practical Solution

	test = IperfTest(100,1,64,51007,"10.0.1.3",str(str(testName) + "OnPSVM1_" + str(count)),"146.164.69.149","5001")

	kp=float(-0.000003422)
	ki=float(0.000010158)

	physicalHost = PhysicalHost("floresta","xen+ssh")
	desiredThroughput = 20000
	samplePeriod = 1
	errorPercentageAcceptable = 0.1
	minPercentageSamplePeriod = 1
	constantCap = 0
	operationalPointThroughput = 40007
	control = ThroughputControl	(kp,ki,operationalPointThroughput,desiredThroughput,samplePeriod,errorPercentageAcceptable,minPercentageSamplePeriod,constantCap,3,physicalHost,test)
	control.runFeedackControl()

	statistic = Statistics(str(str(testName) + "OnPSVM1_" + str(count)),20)


	output = open(str(testName + "Average"),'a')
	output.write("4 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("4 " + str(statistic.rmse) + "\n")
	output.close()	
	output = open(str(testName + "ReducedMessages"),'a')
	percentageReduced = float(1) - (float(control.actionsCount)/float(control.samplesCount))
	print str(control.actionsCount) + " / " + str(control.samplesCount)
	output.write("4 " + str(percentageReduced) + "\n")
	output.close()

	print "Controller Practical Solution " + str(count) + " done"

	del statistic
	del physicalHost
	del control

	os.popen("sleep 5")

	count = count + 1

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "Average") + ' >> ' + str(testName + "Average.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "RMSE") + ' >> ' + str(testName + "RMSE.dt") + "") 

