#!/usr/bin/python -u
import os
import xenprototypeModulesCarrier
import subprocess
from xenprototype.VirtualManagementLib.virtualManagement import PhysicalHost
from xenprototype.CpuAllocation.cpuFeedbackControl import *
from xenprototype.CpuAllocation.statistics import *
from xenprototype.CpuAllocation.throughputTest import *

testName = "parametersAandBevaluation_2"

rounds = 100
count = 1
prefix = "eXpErImEnT"
testName = prefix + testName

os.popen("rm " + str(testName) + "*")

cmd1 = "killall iperf"

cmd2 = "ssh root@tartaruga" +  " \" " + "killall iperf"  " \" "

subprocess.Popen(cmd1, stdout=subprocess.PIPE, shell=True)

subprocess.Popen(cmd2, stdout=subprocess.PIPE, shell=True)

#Control Settings
physicalHost = PhysicalHost("floresta","xen+ssh")
domainID = 14

#Initial instantiations
#test1 = IperfTest(duration,samplePeriod,packetLength,bitRate,destination,filename,trafficReceiver,trafficPort)
lista = ["vif1.1"]

while (count <= rounds):

	#Perform the experiment using Adaptive Controller With 20k of reference input

	physicalHost = PhysicalHost("floresta","xen+ssh")

	medida = IperfTest(100,1,64,51200,"10.0.5.3",str(str(testName) + "Adaptive20k_" + str(count)),"146.164.69.149","5001")

	desiredThroughput = 20000

	adpativeOn = True

	control = ThroughputControl(desiredThroughput,domainID,physicalHost,medida,adpativeOn)

	control.runFeedackControl()

	statistic = Statistics(str(str(testName) + "Adaptive20k_" + str(count)),20)

	output = open(str(testName + "Average"),'a')
	output.write("1 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("1 " + str(statistic.rmse) + "\n")
	output.close()	

	del statistic

	statistic = Statistics(str(str(testName) + "Adaptive20k_" + str(count) + "_parameterA" ),0)

	output = open(str(testName + "Average" + "_parameterA"),'a')
	output.write("1 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE" + "_parameterA"),'a')
	output.write("1 " + str(statistic.rmse) + "\n")
	output.close()	

	del statistic

	statistic = Statistics(str(str(testName) + "Adaptive20k_" + str(count) + "_parameterB" ),0)

	output = open(str(testName + "Average" + "_parameterB"),'a')
	output.write("1 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE" + "_parameterB"),'a')
	output.write("1 " + str(statistic.rmse) + "\n")
	output.close()

	print "Controller Adpative 20k" + str(count) + " done"

	cmd1 = "killall iperf"

	cmd2 = "ssh root@tartaruga" +  " \" " + "killall iperf"  " \" "

	subprocess.Popen(cmd1, stdout=subprocess.PIPE, shell=True)

	subprocess.Popen(cmd2, stdout=subprocess.PIPE, shell=True)

	del statistic
	del physicalHost
	del control
	del medida

	os.popen("sleep 10")


	#Perform the experiment using Adaptive Controller With 15k of reference input

	physicalHost = PhysicalHost("floresta","xen+ssh")

	medida = IperfTest(100,1,64,51200,"10.0.5.3",str(str(testName) + "Adaptive15k_" + str(count)),"146.164.69.149","5001")

	desiredThroughput = 15000

	adpativeOn = True

	control = ThroughputControl(desiredThroughput,domainID,physicalHost,medida,adpativeOn)

	control.runFeedackControl()

	statistic = Statistics(str(str(testName) + "Adaptive15k_" + str(count)),20)

	output = open(str(testName + "Average"),'a')
	output.write("2 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("2 " + str(statistic.rmse) + "\n")
	output.close()	

	del statistic

	statistic = Statistics(str(str(testName) + "Adaptive15k_" + str(count) + "_parameterA" ),0)

	output = open(str(testName + "Average" + "_parameterA"),'a')
	output.write("2 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE" + "_parameterA"),'a')
	output.write("2 " + str(statistic.rmse) + "\n")
	output.close()	

	del statistic

	statistic = Statistics(str(str(testName) + "Adaptive15k_" + str(count) + "_parameterB" ),0)

	output = open(str(testName + "Average" + "_parameterB"),'a')
	output.write("2 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE" + "_parameterB"),'a')
	output.write("2 " + str(statistic.rmse) + "\n")
	output.close()

	print "Controller Adpative 15k" + str(count) + " done"

	cmd1 = "killall iperf"

	cmd2 = "ssh root@tartaruga" +  " \" " + "killall iperf"  " \" "

	subprocess.Popen(cmd1, stdout=subprocess.PIPE, shell=True)

	subprocess.Popen(cmd2, stdout=subprocess.PIPE, shell=True)

	del statistic
	del physicalHost
	del control
	del medida

	os.popen("sleep 10")

	count = count + 1

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "Average") + ' >> ' + str(testName + "Average.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "RMSE") + ' >> ' + str(testName + "RMSE.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "Average" + "_parameterA") + ' >> ' + str(testName + "Average_parameterA.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "RMSE" + "_parameterA" ) + ' >> ' + str(testName + "RMSE_parameterA.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "Average" + "_parameterB") + ' >> ' + str(testName + "Average_parameterB.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "RMSE" + "_parameterB" ) + ' >> ' + str(testName + "RMSE_parameterB.dt") + "") 

