#!/usr/bin/python -u
import os
import xenprototypeModulesCarrier
import subprocess
from xenprototype.VirtualManagementLib.virtualManagement import PhysicalHost
from xenprototype.CpuAllocation.cpuFeedbackControlGeneric import *
from xenprototype.CpuAllocation.statistics import *
from xenprototype.CpuAllocation.measureThroughput import *

testName = "ComparissonAdaptive"

rounds = 10
count = 1
prefix = "eXpErImEnT"
testName = prefix + testName

os.popen("rm " + str(testName) + "*")

#Control Settings
physicalHost = PhysicalHost("floresta","xen+ssh")
domainID = 1

#Initial instantiations
#test1 = IperfTest(duration,samplePeriod,packetLength,bitRate,destination,filename,trafficReceiver,trafficPort)
lista = ["vif1.1"]

while (count <= rounds):

	#Perform the experiment using Non Adaptive Controller With 20k of reference input

	os.popen("ssh root@floresta \" killall measureThroughputServer.py \"")

	physicalHost = PhysicalHost("floresta","xen+ssh")

	cmd1 = "ssh root@tartaruga" +  " \" " + "iperf -su -l 64" + " \" "
	
	cmd2 = "iperf -c 10.0.1.3 -b 51200k -f k -l 64 -t 115 "

	subprocess.Popen(cmd1, stdout=subprocess.PIPE, shell=True)

	subprocess.Popen(cmd2, stdout=subprocess.PIPE, shell=True)

	medida = MeasureClient("floresta",50012,lista,100,str(str(testName) + "NonAdaptive20k_" + str(count)))

	kp=float(-0.000003422)
	ki=float(0.000010158)

	desiredThroughput = 20000

	adpativeOn = False

	domainID = 1

	control = ThroughputControl(desiredThroughput,domainID,physicalHost,medida,adpativeOn)

	control.runFeedackControl()

	statistic = Statistics(str(str(testName) + "NonAdaptive20k_" + str(count)),20)

	output = open(str(testName + "Average"),'a')
	output.write("1 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("1 " + str(statistic.rmse) + "\n")
	output.close()	

	print "Controller Non-Adpative 20k" + str(count) + " done"

	cmd1 = "killall iperf"

	cmd2 = "ssh root@tartaruga" +  " \" " + "killall iperf"  " \" "

	subprocess.Popen(cmd1, stdout=subprocess.PIPE, shell=True)

	subprocess.Popen(cmd2, stdout=subprocess.PIPE, shell=True)

	del statistic
	del physicalHost
	del control
	del medida

	os.popen("sleep 10")

	#Perform the experiment using Adaptive Controller With 20k of reference input

	os.popen("ssh root@floresta \" killall measureThroughputServer.py \"")

	physicalHost = PhysicalHost("floresta","xen+ssh")

	cmd1 = "ssh root@tartaruga" +  " \" " + "iperf -su -l 64"  " \" "
	
	cmd2 = "iperf -c 10.0.1.3 -b 51200k -f k -l 64 -t 115 "

	subprocess.Popen(cmd1, stdout=subprocess.PIPE, shell=True)

	subprocess.Popen(cmd2, stdout=subprocess.PIPE, shell=True)

	medida = MeasureClient("floresta",50012,lista,100,str(str(testName) + "Adaptive20k_" + str(count)))

	desiredThroughput = 20000

	adpativeOn = True

	domainID = 1

	control = ThroughputControl(desiredThroughput,domainID,physicalHost,medida,adpativeOn)

	control.runFeedackControl()

	statistic = Statistics(str(str(testName) + "Adaptive20k_" + str(count)),20)

	output = open(str(testName + "Average"),'a')
	output.write("2 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("2 " + str(statistic.rmse) + "\n")
	output.close()	

	print "Controller Adpative 20k" + str(count) + " done"

	cmd1 = "killall iperf"

	cmd2 = "ssh root@tartaruga" +  " \" " + "killall iperf"  " \" "

	subprocess.Popen(cmd1, stdout=subprocess.PIPE, shell=True)

	subprocess.Popen(cmd2, stdout=subprocess.PIPE, shell=True)

	del statistic
	del physicalHost
	del control
	del medida

	os.popen("sleep 10")

	#Perform the experiment using Non Adaptive Controller With 15k of reference input

	os.popen("ssh root@floresta \" killall measureThroughputServer.py \"")

	physicalHost = PhysicalHost("floresta","xen+ssh")

	cmd1 = "ssh root@tartaruga" +  " \" " + "iperf -su -l 64"  " \" "
	
	cmd2 = "iperf -c 10.0.1.3 -b 51200k -f k -l 64 -t 115 "

	subprocess.Popen(cmd1, stdout=subprocess.PIPE, shell=True)

	subprocess.Popen(cmd2, stdout=subprocess.PIPE, shell=True)

	medida = MeasureClient("floresta",50012,lista,100,str(str(testName) + "NonAdaptive15k_" + str(count)))

	kp=float(-0.000003422)
	ki=float(0.000010158)

	desiredThroughput = 15000

	adpativeOn = False

	domainID = 1

	control = ThroughputControl(desiredThroughput,domainID,physicalHost,medida,adpativeOn)

	control.runFeedackControl()

	statistic = Statistics(str(str(testName) + "NonAdaptive15k_" + str(count)),20)

	output = open(str(testName + "Average"),'a')
	output.write("3 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("3 " + str(statistic.rmse) + "\n")
	output.close()	

	print "Controller Non-Adpative 15k" + str(count) + " done"

	cmd1 = "killall iperf"

	cmd2 = "ssh root@tartaruga" +  " \" " + "killall iperf"  " \" "

	subprocess.Popen(cmd1, stdout=subprocess.PIPE, shell=True)

	subprocess.Popen(cmd2, stdout=subprocess.PIPE, shell=True)

	del statistic
	del physicalHost
	del control
	del medida

	os.popen("sleep 10")


	#Perform the experiment using Adaptive Controller With 15k of reference input

	os.popen("ssh root@floresta \" killall measureThroughputServer.py \"")

	physicalHost = PhysicalHost("floresta","xen+ssh")

	cmd1 = "ssh root@tartaruga" +  " \" " + "iperf -su -l 64"  " \" "
	
	cmd2 = "iperf -c 10.0.1.3 -b 51200k -f k -l 64 -t 115 "

	subprocess.Popen(cmd1, stdout=subprocess.PIPE, shell=True)

	subprocess.Popen(cmd2, stdout=subprocess.PIPE, shell=True)

	medida = MeasureClient("floresta",50012,lista,100,str(str(testName) + "Adaptive15k_" + str(count)))

	desiredThroughput = 15000

	adpativeOn = True

	domainID = 1

	control = ThroughputControl(desiredThroughput,domainID,physicalHost,medida,adpativeOn)

	control.runFeedackControl()

	statistic = Statistics(str(str(testName) + "Adaptive15k_" + str(count)),20)

	output = open(str(testName + "Average"),'a')
	output.write("4 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("4 " + str(statistic.rmse) + "\n")
	output.close()	

	print "Controller Adpative 15k" + str(count) + " done"

	cmd1 = "killall iperf"

	cmd2 = "ssh root@tartaruga" +  " \" " + "killall iperf"  " \" "

	subprocess.Popen(cmd1, stdout=subprocess.PIPE, shell=True)

	subprocess.Popen(cmd2, stdout=subprocess.PIPE, shell=True)

	del statistic
	del physicalHost
	del control
	del medida

	os.popen("sleep 10")

	count = count + 1

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "Average") + ' >> ' + str(testName + "Average.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "RMSE") + ' >> ' + str(testName + "RMSE.dt") + "") 

