#!/usr/bin/python -u
import os
import xenprototypeModulesCarrier
from xenprototype.VirtualManagementLib.virtualManagement import PhysicalHost
from xenprototype.CpuAllocation.cpuFeedbackControlGeneric import *
from xenprototype.CpuAllocation.statistics import *
from xenprototype.CpuAllocation.measureThroughput import *

testName = "bottleneckThreeOnVM"

rounds = 30
count = 1
prefix = "eXpErImEnT"
testName = prefix + testName

os.popen("rm " + str(testName) + "*")

#Set pin parameters

os.popen("ssh root@floresta \" xm vcpu-pin vm01 0 7 \"")
os.popen("ssh root@floresta \" xm vcpu-pin vm02 0 6 \"")
os.popen("ssh root@floresta \" xm vcpu-pin vm03 0 5 \"")
os.popen("ssh root@floresta \" xm vcpu-set 0 2 \"")
os.popen("ssh root@floresta \" xm vcpu-pin 0 0 0 \"")
os.popen("ssh root@floresta \" xm vcpu-pin 0 1 1 \"")

while (count <= rounds):

	physicalHost = PhysicalHost("floresta","xen+ssh")
	physicalHost.setSchedParametersCap(0,1)
	physicalHost.setSchedParametersCap(0,5)
	physicalHost.setSchedParametersCap(0,6)
	physicalHost.printSchedParameters()

	#Kill the existent processes

	os.popen("killall iperf")

	os.popen("ssh root@floresta \" killall measureThroughputServer.py \"")
	
	os.popen("ssh root@floresta \" killall iperf \"")

	#Instantiate the measure objects

	lista1 = ["vif1.1"]

	medida1  = MeasureClient("floresta",50011,lista1,100,str(str(testName) + "OnVM1_" + str(count)))

	lista2 = ["vif5.1"]

	medida2 = MeasureClient("floresta",50012,lista2,100,str(str(testName) + "OnVM2_" + str(count)))

	lista3 = ["vif6.1"]

	medida3 = MeasureClient("floresta",50013,lista3,100,str(str(testName) + "OnVM3_" + str(count)))

	#Instantiate the controler objects

	#Settings for VM1

	desiredThroughput = 30000

	control1 = ThroughputControl(desiredThroughput,1,physicalHost,medida1,True)

	#Settings for VM2
	
	desiredThroughput = 15000

	control2 = ThroughputControl(desiredThroughput,5,physicalHost,medida2,True)

	#Settings for VM3

	desiredThroughput = 15000

	control3 = ThroughputControl(desiredThroughput,6,physicalHost,medida3,True)


	print "controles instanciados"


	#Start the Iperf experiments

	physicalHost = PhysicalHost("floresta","xen+ssh")

	cmd1a = "ssh root@tartaruga" +  " \" " + "iperf -su -l 64 -p 5001" + " \" "
	
	cmd2a = "ssh root@tartaruga" +  " \" " + "iperf -su -l 64 -p 5002" + " \" "
	
	cmd3a = "ssh root@tartaruga" +  " \" " + "iperf -su -l 64 -p 5003" + " \" "
	
	cmd1b = "iperf -c 10.0.1.3 -b 51200k -f k -l 64 -t 130 -p 5001"
	
	cmd2b = "iperf -c 10.0.3.3 -b 51200k -f k -l 64 -t 130 -p 5002"
	
	cmd3b = "iperf -c 10.0.5.3 -b 51200k -f k -l 64 -t 130 -p 5003"

	subprocess.Popen(cmd1a, stdout=subprocess.PIPE, shell=True)
	subprocess.Popen(cmd2a, stdout=subprocess.PIPE, shell=True)
	subprocess.Popen(cmd3a, stdout=subprocess.PIPE, shell=True)

	time.sleep(1)

	subprocess.Popen(cmd1b, stdout=subprocess.PIPE, shell=True)
	subprocess.Popen(cmd2b, stdout=subprocess.PIPE, shell=True)
	subprocess.Popen(cmd3b, stdout=subprocess.PIPE, shell=True)	

	time.sleep(10)
	
	#Starting the controlers

	ControlThread("10001",control1).start()
	ControlThread("10002",control2).start()
	ControlThread("10003",control3).start()

	print "controles iniciados"

	while (control1.done == False) or (control2.done == False) or (control3.done == False):
		#physicalHost.printSchedParameters()
		os.popen("sleep 1")

	averageThroughputList=[]

	os.popen("sleep 5")

	#Compute statistics for VM1	

	statistic = Statistics(str(str(testName) + "OnVM1_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("4 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("4 " + str(statistic.rmse) + "\n")
	output.close()	

	averageThroughputList.append(statistic.average)
	del statistic

	#Compute statistics for VM2	

	statistic = Statistics(str(str(testName) + "OnVM2_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("5 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("5 " + str(statistic.rmse) + "\n")
	output.close()

	averageThroughputList.append(statistic.average)
	del statistic	

	#Compute statistics for VM3	

	statistic = Statistics(str(str(testName) + "OnVM3_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("6 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("6 " + str(statistic.rmse) + "\n")
	output.close()

	averageThroughputList.append(statistic.average)
	del statistic

	#Compute Fairness

	fairness = Fairness(averageThroughputList)

	output = open(str(testName + "JainFairness"),'a')
	output.write("2 " + str(fairness.jainFairness) + "\n")
	output.close()
	del fairness

	del medida1
	del medida2
	del medida3
	del physicalHost
	del control1
	del control2
	del control3

	cmd1 = "killall iperf"

	cmd2 = "ssh root@tartaruga" +  " \" " + "killall iperf"  " \" "

	subprocess.Popen(cmd1, stdout=subprocess.PIPE, shell=True)

	subprocess.Popen(cmd2, stdout=subprocess.PIPE, shell=True)

	print "Done " + str(count)
	
	count = count + 1

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "Average") + ' >> ' + str(testName + "Average.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "RMSE") + ' >> ' + str(testName + "RMSE.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "JainFairness") + ' >> ' + str(testName + "JainFairness.dt") + "") 

