#!/usr/bin/python -u
import os
import xenprototypeModulesCarrier
import time
from xenprototype.VirtualManagementLib.virtualManagement import PhysicalHost
from xenprototype.CpuAllocation.cpuFeedbackControlGeneric import *
from xenprototype.CpuAllocation.statistics import *
from xenprototype.CpuAllocation.measureThroughput import *

testName = "bottleneckThreeOffVM"
onTestName = "bottleneckThreeOnVM"

rounds = 30
count = 1
prefix = "eXpErImEnT"
testName = prefix + testName
onTestName = prefix + onTestName

os.popen("rm " + str(testName) + "*")
os.popen("rm " + str(onTestName) + "*")

#Set pin parameters

os.popen("ssh root@floresta \" xm vcpu-pin vm01 0 7 \"")
os.popen("ssh root@floresta \" xm vcpu-pin vm02 0 6 \"")
os.popen("ssh root@floresta \" xm vcpu-pin vm03 0 5 \"")
os.popen("ssh root@floresta \" xm vcpu-set 0 2 \"")
os.popen("ssh root@floresta \" xm vcpu-pin 0 0 0 \"")
os.popen("ssh root@floresta \" xm vcpu-pin 0 1 1 \"")

while (count <= rounds):

	physicalHost = PhysicalHost("floresta","xen+ssh")
	physicalHost.setSchedParametersCap(0,1)
	physicalHost.setSchedParametersCap(0,5)
	physicalHost.setSchedParametersCap(0,6)
	physicalHost.printSchedParameters()

	#Kill the existent processes

	os.popen("killall iperf")

	os.popen("ssh root@floresta \" killall measureThroughputServer.py \"")
	
	os.popen("ssh root@floresta \" killall iperf \"")

	print "Processos Terminados"

	#Instantiate the measure objects

	lista1 = ["vif1.1"]

	medida1  = MeasureClient("floresta",50011,lista1,100,str(str(testName) + "OffVM1_" + str(count)))

	lista2 = ["vif5.1"]

	medida2 = MeasureClient("floresta",50012,lista2,100,str(str(testName) + "OffVM2_" + str(count)))

	lista3 = ["vif6.1"]

	medida3 = MeasureClient("floresta",50013,lista3,100,str(str(testName) + "OffVM3_" + str(count)))

	#Start the Iperf experiments

	physicalHost = PhysicalHost("floresta","xen+ssh")

	cmd1a = "ssh root@tartaruga" +  " \" " + "iperf -su -l 64 -p 5001" + " \" "
	
	cmd2a = "ssh root@tartaruga" +  " \" " + "iperf -su -l 64 -p 5002" + " \" "
	
	cmd3a = "ssh root@tartaruga" +  " \" " + "iperf -su -l 64 -p 5003" + " \" "
	
	cmd1b = "iperf -c 10.0.1.3 -b 51200k -f k -l 64 -t 130 -p 5001"
	
	cmd2b = "iperf -c 10.0.3.3 -b 51200k -f k -l 64 -t 130 -p 5002"
	
	cmd3b = "iperf -c 10.0.5.3 -b 51200k -f k -l 64 -t 130 -p 5003"

	subprocess.Popen(cmd1a, stdout=subprocess.PIPE, shell=True)
	subprocess.Popen(cmd2a, stdout=subprocess.PIPE, shell=True)
	subprocess.Popen(cmd3a, stdout=subprocess.PIPE, shell=True)

	time.sleep(1)

	subprocess.Popen(cmd1b, stdout=subprocess.PIPE, shell=True)
	subprocess.Popen(cmd2b, stdout=subprocess.PIPE, shell=True)
	subprocess.Popen(cmd3b, stdout=subprocess.PIPE, shell=True)

	while (medida1.connectionStatus == False) or (medida2.connectionStatus == False) or (medida3.connectionStatus == False):
		print "Waiting Connection"
		time.sleep(0.5)	

	time.sleep(5)
	
	#Starting the measures

	MeasureClientThread("3",medida1).start()	
	MeasureClientThread("4",medida2).start()
	MeasureClientThread("5",medida3).start()

	os.popen("sleep 5")
	

	print "Sensores Instanciados"

	while (medida1.getExperimentStatus() == True) or (medida2.getExperimentStatus() == True) or (medida3.getExperimentStatus() == True):
		#print "Wait"
		os.popen("sleep 1")

	averageThroughputList=[]

	os.popen("sleep 5")

	#Compute statistics for VM1	

	statistic = Statistics(str(str(testName) + "OffVM1_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("4 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("4 " + str(statistic.rmse) + "\n")
	output.close()	

	averageThroughputList.append(statistic.average)
	del statistic

	#Compute statistics for VM2	

	statistic = Statistics(str(str(testName) + "OffVM2_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("5 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("5 " + str(statistic.rmse) + "\n")
	output.close()

	averageThroughputList.append(statistic.average)
	del statistic	

	#Compute statistics for VM3	

	statistic = Statistics(str(str(testName) + "OffVM3_" + str(count)),20)
	output = open(str(testName + "Average"),'a')
	output.write("6 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(testName + "RMSE"),'a')
	output.write("6 " + str(statistic.rmse) + "\n")
	output.close()

	averageThroughputList.append(statistic.average)
	del statistic

	#Compute Fairness

	fairness = Fairness(averageThroughputList)

	output = open(str(testName + "JainFairness"),'a')
	output.write("2 " + str(fairness.jainFairness) + "\n")
	output.close()
	del fairness

	del medida1
	del medida2
	del medida3
	del physicalHost

	cmd1 = "killall iperf"

	cmd2 = "ssh root@tartaruga" +  " \" " + "killall iperf"  " \" "

	subprocess.Popen(cmd1, stdout=subprocess.PIPE, shell=True)

	subprocess.Popen(cmd2, stdout=subprocess.PIPE, shell=True)

	print "Done Off " + str(count)

	"""
	time.sleep(10)
	
	physicalHost = PhysicalHost("floresta","xen+ssh")
	physicalHost.setSchedParametersCap(0,1)
	physicalHost.setSchedParametersCap(0,3)
	physicalHost.setSchedParametersCap(0,4)
	physicalHost.printSchedParameters()

	#Kill the existent processes

	os.popen("killall iperf")

	os.popen("ssh root@floresta \" killall measureThroughputServer.py \"")
	
	os.popen("ssh root@floresta \" killall iperf \"")

	#Instantiate the measure objects

	lista1 = ["vif1.1"]

	medida1  = MeasureClient("floresta",50011,lista1,100,str(str(onTestName) + "OnVM1_" + str(count)))

	lista2 = ["vif3.1"]

	medida2 = MeasureClient("floresta",50012,lista2,100,str(str(onTestName) + "OnVM2_" + str(count)))

	lista3 = ["vif4.1"]

	medida3 = MeasureClient("floresta",50013,lista3,100,str(str(onTestName) + "OnVM3_" + str(count)))

	#Instantiate the controler objects

	#Settings for VM1

	desiredThroughput = 30000

	control1 = ThroughputControl(desiredThroughput,1,physicalHost,medida1,True)

	#Settings for VM2
	
	desiredThroughput = 15000

	control2 = ThroughputControl(desiredThroughput,3,physicalHost,medida2,True)

	#Settings for VM3

	desiredThroughput = 15000

	control3 = ThroughputControl(desiredThroughput,4,physicalHost,medida3,True)


	print "controles instanciados"


	#Start the Iperf experiments

	physicalHost = PhysicalHost("floresta","xen+ssh")

	cmd1a = "ssh root@tartaruga" +  " \" " + "iperf -su -l 64 -p 5001" + " \" "
	
	cmd2a = "ssh root@tartaruga" +  " \" " + "iperf -su -l 64 -p 5002" + " \" "
	
	cmd3a = "ssh root@tartaruga" +  " \" " + "iperf -su -l 64 -p 5003" + " \" "
	
	cmd1b = "iperf -c 10.0.1.3 -b 51200k -f k -l 64 -t 115 -p 5001"
	
	cmd2b = "iperf -c 10.0.3.3 -b 51200k -f k -l 64 -t 115 -p 5002"
	
	cmd3b = "iperf -c 10.0.5.3 -b 51200k -f k -l 64 -t 115 -p 5003"

	subprocess.Popen(cmd1a, stdout=subprocess.PIPE, shell=True)
	subprocess.Popen(cmd2a, stdout=subprocess.PIPE, shell=True)
	subprocess.Popen(cmd3a, stdout=subprocess.PIPE, shell=True)

	time.sleep(1)

	subprocess.Popen(cmd1b, stdout=subprocess.PIPE, shell=True)
	subprocess.Popen(cmd2b, stdout=subprocess.PIPE, shell=True)
	subprocess.Popen(cmd3b, stdout=subprocess.PIPE, shell=True)	
	
	#Starting the controlers

	ControlThread("10001",control1).start()
	ControlThread("10002",control2).start()
	ControlThread("10003",control3).start()

	print "controles iniciados"

	while (control1.done == False) and (control2.done == False) and (control3.done == False):
		#physicalHost.printSchedParameters()
		os.popen("sleep 1")

	averageThroughputList=[]

	os.popen("sleep 5")

	#Compute statistics for VM1	

	statistic = Statistics(str(str(onTestName) + "OnVM1_" + str(count)),20)
	output = open(str(onTestName + "Average"),'a')
	output.write("4 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(onTestName + "RMSE"),'a')
	output.write("4 " + str(statistic.rmse) + "\n")
	output.close()	

	averageThroughputList.append(statistic.average)
	del statistic

	#Compute statistics for VM2	

	statistic = Statistics(str(str(onTestName) + "OnVM2_" + str(count)),20)
	output = open(str(onTestName + "Average"),'a')
	output.write("5 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(onTestName + "RMSE"),'a')
	output.write("5 " + str(statistic.rmse) + "\n")
	output.close()

	averageThroughputList.append(statistic.average)
	del statistic	

	#Compute statistics for VM3	

	statistic = Statistics(str(str(onTestName) + "OnVM3_" + str(count)),20)
	output = open(str(onTestName + "Average"),'a')
	output.write("6 " + str(statistic.average) + "\n")
	output.close()
	output = open(str(onTestName + "RMSE"),'a')
	output.write("6 " + str(statistic.rmse) + "\n")
	output.close()

	averageThroughputList.append(statistic.average)
	del statistic

	#Compute Fairness

	fairness = Fairness(averageThroughputList)

	output = open(str(onTestName + "JainFairness"),'a')
	output.write("2 " + str(fairness.jainFairness) + "\n")
	output.close()
	del fairness

	del medida1
	del medida2
	del medida3
	del physicalHost
	del control1
	del control2
	del control3

	cmd1 = "killall iperf"

	cmd2 = "ssh root@tartaruga" +  " \" " + "killall iperf"  " \" "

	subprocess.Popen(cmd1, stdout=subprocess.PIPE, shell=True)

	subprocess.Popen(cmd2, stdout=subprocess.PIPE, shell=True)

	print "Done " + str(count)

	"""

	count = count + 1

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "Average") + ' >> ' + str(testName + "Average.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "RMSE") + ' >> ' + str(testName + "RMSE.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(testName + "JainFairness") + ' >> ' + str(testName + "JainFairness.dt") + "") 


os.popen('./ic.awk nrvar=1 ic=95 ' + str(onTestName + "Average") + ' >> ' + str(onTestName + "Average.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(onTestName + "RMSE") + ' >> ' + str(onTestName + "RMSE.dt") + "") 

os.popen('./ic.awk nrvar=1 ic=95 ' + str(onTestName + "JainFairness") + ' >> ' + str(onTestName + "JainFairness.dt") + "") 

