#!/usr/bin/python -u

from math import sqrt

#Evaluate the average value, discarding the first discardSamples samples

class Statistics():
	def __init__(self,fileName,discardSamples):
		self.fileName = fileName	
		resultFile = open(self.fileName,'r')
		sumY=float(0)
		samples=0
		samplesMean=0
		self.resultOk = "False"
		for line in resultFile:
			samples = samples + 1
			if (samples >= discardSamples):
				sumY = sumY + float(line.split(" ")[1])
				samplesMean = samplesMean + 1

		if (samplesMean != 0):
			average = float(sumY)/float(samplesMean)

			self.average = average

			resultFile.close()
			resultFile = open(self.fileName,'r')

			samples=0
			samplesMean=0
			sumError = float(0) 
			for line in resultFile:
				samples = samples + 1
				if (samples >= discardSamples):
					error = (float(line.split(" ")[1]) - float(average))**2
					sumError = sumError + error
					samplesMean = samplesMean + 1
	
			rmse = sqrt(float(sumError)/float(samplesMean))
	
			self.rmse = rmse
			
			resultFile.close()
			
			self.resultOk = "True"

		else:
			self.average = "Fail"
			self.rmse = "Fail"
			
			

class Fairness():
	def __init__(self,measureList):

		sumX = float(0)
		sumXsquare = float(0)
		countX = float(0)
		error = "False"
		for x in measureList:
			if ( str(x) != "Fail"):
				sumX = sumX + float(x)
				sumXsquare = sumXsquare + float(x**2)
				countX = countX + 1
			else:
				error = "True"
	
		if (error == "False"):
			self.jainFairness = float((sumX**2))/float(countX*sumXsquare)
		else:
			self.jainFairness = "Fail"
		

