%Apaga possiveis variaveis existentes
clear up yp mu my u y H theta a b yhat rmse r2 cc nrmse
%Transforma os valores de cap (up) em log na base 10
up = log10(vals(:,1));
%Transforma os valores de vazao (yp) em bit/s para kbit/s
yp = vals(:,2)/1000;
%Calcula ponto de operacao para as variaveis up e yp
mu = mean(up(1:end-1));
my = mean(yp(2:end));
%Calcula o offset das variaveis up e yp
u = up - mu;
y = yp - my;
%Calcula os parametros a e b a partir da funcao mldivide
%Essa funcao e acessada pelo operador '\'
H = [y(1:end-1) u(1:end-1)];
theta = H\y(2:end)
a = theta(1)
b = theta(2)
%Plota o Grafico de Residuos, calculando os valores estimados de vazao (yhat)
yhat = a*y(1:end-1) + b*u(1:end-1);
plot(y(2:end),yhat,' * ',y,y,' -');
%Calcula a metrica r-square
r2 = rsquare(y(2:end),yhat) 
