#!/usr/bin/python -u
import os
import xenprototypeModulesCarrier
from xenprototype.VirtualManagementLib.virtualManagement import PhysicalHost
from xenprototype.CpuAllocation.cpuFeedbackControl import *
from xenprototype.CpuAllocation.throughputTest import *
from xenprototype.CpuAllocation.statistics import *

#Test Settings
duration = 100
samplePeriod = 1
packetLength = 64
bitRate = 51200
destination = "10.0.5.3"
filename = "debugTestAdaptive"
trafficReceiver = "146.164.69.149"
trafficPort = "5001"

#Control Settings
physicalHost = PhysicalHost("floresta","xen+ssh")
desiredThroughput = 15000
domainID = 14


#Initial instantiations
test1 = IperfTest(duration,samplePeriod,packetLength,bitRate,destination,filename,trafficReceiver,trafficPort)
control = ThroughputControl(desiredThroughput,domainID,physicalHost,test1,True)

#Start the experiment
control.runFeedackControl()

#Show statistics
statistic = Statistics(filename,20)
print str(statistic.average)
print str(statistic.rmse)

name = filename + "_parameterA"
statistic1 = Statistics(name,0)
print str("a = ") + " " + str(statistic1.average)
print str(statistic1.rmse)

name = filename + "_parameterB"
statistic2 = Statistics(name,0)
print str("b = ") + " " + str(statistic2.average)
print str(statistic2.rmse)
